

<?php $__env->startSection('title', 'My Availability Schedule'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 sm:mb-6 gap-3">
        <h1 class="text-2xl sm:text-3xl font-bold text-gray-800">My Availability Schedule</h1>
        <a href="<?php echo e(route('doctor.dashboard')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-3 sm:px-4 py-2 rounded text-sm sm:text-base">
            <i class="fas fa-arrow-left"></i> <span class="hidden sm:inline">Back to Dashboard</span><span class="sm:hidden">Back</span>
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- Add Availability Form -->
    <div class="bg-white rounded-lg shadow p-4 sm:p-6 mb-6">
        <h2 class="text-xl font-bold mb-4">Add Availability Slot</h2>
        <form method="POST" action="<?php echo e(route('doctor.availability.store')); ?>" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <?php echo csrf_field(); ?>
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Day of Week *</label>
                <select name="day_of_week" required class="w-full px-3 py-2 border rounded">
                    <option value="">Select Day</option>
                    <option value="monday">Monday</option>
                    <option value="tuesday">Tuesday</option>
                    <option value="wednesday">Wednesday</option>
                    <option value="thursday">Thursday</option>
                    <option value="friday">Friday</option>
                    <option value="saturday">Saturday</option>
                    <option value="sunday">Sunday</option>
                </select>
            </div>
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">Start Time *</label>
                <input type="time" name="start_time" required class="w-full px-3 py-2 border rounded">
            </div>
            <div>
                <label class="block text-gray-700 text-sm font-bold mb-2">End Time *</label>
                <input type="time" name="end_time" required class="w-full px-3 py-2 border rounded">
            </div>
            <div class="flex items-end">
                <label class="flex items-center">
                    <input type="checkbox" name="is_available" value="1" checked class="mr-2">
                    <span class="text-gray-700 text-sm font-bold">Available</span>
                </label>
            </div>
            <div class="flex items-end">
                <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded text-sm sm:text-base">
                    <i class="fas fa-plus"></i> Add Slot
                </button>
            </div>
        </form>
    </div>

    <!-- Current Availability Schedule -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="p-4 sm:p-6 border-b">
            <h2 class="text-xl font-bold">Current Schedule</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Day</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Start Time</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">End Time</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-3 sm:px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $availabilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $availability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm sm:text-base font-medium capitalize"><?php echo e($availability->day_of_week); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm"><?php echo e(date('H:i', strtotime($availability->start_time))); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <span class="text-sm"><?php echo e(date('H:i', strtotime($availability->end_time))); ?></span>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap">
                            <?php if($availability->is_available): ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Available</span>
                            <?php else: ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">Unavailable</span>
                            <?php endif; ?>
                        </td>
                        <td class="px-3 sm:px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <form method="POST" action="<?php echo e(route('doctor.availability.delete', $availability->id)); ?>" class="inline" onsubmit="return confirm('Are you sure you want to delete this availability slot?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900">
                                    <i class="fas fa-trash"></i> <span class="hidden sm:inline">Delete</span>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            <i class="fas fa-calendar-times text-4xl mb-2"></i>
                            <p>No availability schedule set. Add your available times above.</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if($availabilities->count() > 0): ?>
    <div class="mt-4 text-sm text-gray-600">
        <p><strong>Note:</strong> Your availability schedule is visible to pharmacists when they book appointments. Make sure to keep it updated.</p>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/doctor/availability.blade.php ENDPATH**/ ?>